
#ifndef _1_CRYS_ATP_TST_HASHFLOW_Acceptance_h_H
#define _1_CRYS_ATP_TST_HASHFLOW_Acceptance_h_H



/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "CRYS.h"
#include "CRYS_ATP_TST_Defines.h"
#include "CRYS_FLOW.h"

#if TST_USE_FLOW_DATA/*In case no test vectors are selected - code disabled*/

#ifdef __cplusplus
extern "C"
{
#endif


  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Tue Nov 14 10:18:14 2007
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_HASHFLOW_Acceptance.h#1:incl:1
   *  \author Annag
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
   

/************************ Defines *******************************/
/************************ Enums *********************************/
/************************ Typedefs  *****************************/
/************************ Structs  ******************************/
typedef struct TST_HASHFLOW_TestDataStruct{	
	char					    TST_Name[TST_NAME_STRING_LEN];

	/* input interrupt id */
	DxUint32_t                  inputInterruptId;

	/* output interrupt id */
	DxUint32_t                  outputInterruptId;


	/* if the data in the buffers are in words and not bytes */ 
	DxUint32_t                  wordsBuffersOrderFlag;

	/* number of input buffers */
	DxUint32_t                  inputBuffersArraySize;

	/* input block size */
	//DxUint16_t                  blockSize;

	/* flag if  endian order of the input buffers is big */
	DxUint32_t                  inputBigEndianOrderFlag;

	/* number of input buffers */
	DxUint32_t                  outputBuffersArraySize;

	/* output block size */
	//DxUint16_t                  outputBlockSize;

	/* flag if  endian order of the output buffers is big */
	DxUint32_t                  outputBigEndianOrderFlag;

	DxUint8_t 			        TST_Expected_output_data[CRYS_HASH_RESULT_SIZE_IN_WORDS*4];
	
	DxUint8_t                   TST_Expected_cyclicOperation_data[CRYS_HASH_RESULT_SIZE_IN_WORDS*4];

	DxUint16_t                  TST_Expected_dataSize;
    
	CRYS_HASH_OperationMode_t	TST_OperationMode;
	
} TST_HASHFLOW_TestDataStruct;


/************************ Public Variables **********************/
/************************ Public Functions **********************/

/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_FLOW_HASHSTATIC_Acceptance
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for static HASH FLOW API's
 
 * Algorithm:     
 *	This function initializes HASH flow with static type and other parameters,
 *  sends interrupts that input and output buffers are ready, finishes HASH flow, 
 *  reads data from the output buffers and compare to expected results
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_HASHSTATIC_Acceptance ( void );

/*****************************************************************************
* Function Name:                                                           
*  CRYS_ATP_TST_FLOW_HASHDYNAMIC_Acceptance
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for dynamic HASH FLOW API's

* Algorithm:     
*	This function initializes HASH flow with dynamic type and other parameters,
*  sends interrupts that input and output buffers are ready, adds buffers to
*  dynamic flow, finishes HASH flow, 
*  reads data from the output buffers and compare to expected results
******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_HASHDYNAMIC_Acceptance ( void );

/*****************************************************************************
* Function Name:                                                           
*  CRYS_ATP_TST_FLOW_HASHDYNAMIC_AddBuffers_Acceptance
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for dynamic HASH FLOW API's

* Algorithm:     
*	This function initializes HASH flow with dynamic type and other parameters,
*  sends interrupts that input and output buffers are ready, adds buffers to
*  dynamic flow, finishes HASH flow, 
*  reads data from the output buffers and compare to expected results
******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_HASHDYNAMIC_AddBuffers_Acceptance ( void );
 
/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_FLOW_HASHSTATIC_Acceptance_WithAdditionalEngines
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for static HASH FLOW API's
 
 * Algorithm:     
 *	This function initializes HASH flow with static type and other parameters,
 *  sends interrupts that input and output buffers are ready, finishes HASH flow, 
 *  reads data from the output buffers and compare to expected results and 
 * execute other CRYS operations during flow
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_HASHSTATIC_Acceptance_WithAdditionalEngines ( void );


/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_FLOW_HASHDYNAMIC_Acceptance_WithAdditionalEngines
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for dynamic HASH FLOW API's
 
 * Algorithm:     
 *	This function initializes HASH flow with static type and other parameters,
 *  sends interrupts that input and output buffers are ready, finishes HASH flow, 
 *  reads data from the output buffers and compare to expected results and 
 * execute other CRYS operations during flow
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_HASHDYNAMIC_Acceptance_WithAdditionalEngines ( void );



/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_FLOW_HASHSTATIC_Cyclic_Acceptance
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for static HASH FLOW API's
 
 * Algorithm:     
 *	This function initializes HASH flow with static type and other parameters,
 * and executes several times flow on the same input buffer
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_HASHSTATIC_Cyclic_Acceptance ( void );

/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_FLOW_HASHS_ONETEST_Acceptance
 *  
 * Inputs:
 *  TST_index          - test index
 *  TST_MasterTestName - test name
 *  flowType           - flow type (static or dynamic)
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for static HASH FLOW API's
 
 * Algorithm:     
 *  1. Initialize HASH flow with type and other parameters
 *  2. Send interrupts that input and output buffers are ready
 *  3. Finish HASH flow and compare result to expected results
 *  4. Terminate flow
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_HASH_ONETEST_Acceptance ( int              TST_index, 
                                                        char             *TST_MasterTestName,
                                                        CRYS_FLOW_Type_t flowType );
                                                        
/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_FLOW_HASHSTATIC_ONETEST_Cyclic_Acceptance
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for static HASH FLOW API's
 
 * Algorithm:     
 * 1. Initialize HASH flow with static type and other parameters 
 * 2. Init HASH flow
 * 3. Send interrupts to execute cyclic flow operation 
 * 4. Finish HASH flow
 * 5. Get results
 * 6. Terminate flow
 * 7. Compare output data to expected result
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_HASHSTATIC_ONETEST_Cyclic_Acceptance ( int   TST_index,
                                                                     char *TST_MasterTestName );
                                                        


/************************ Private Functions **********************/

/*****************************************************************************
* Function Name:                                                           
*  CRYS_ATP_TST_FLOW_CheckHASHOperation
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function checks some HASH operation
* Algorithm:     
*	This function execute some HASH operation and compares result to expected
******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FLOW_CheckHASHOperation (void); 

/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_InitializeHASHFlowInfo
 *  
 * Inputs:
 *  TST_index - test index
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *	This function initialize HASH flow info parameter.
 *
 * Algorithm:     
 *	1. Initialize Flow info parameter.
 *  2. Init HASH flow
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_InitHASHFlow ( int                 TST_index,
                                        CRYS_FLOW_Type_t    flowType,
                                        char               *TST_MasterTestName, 
                                        DxUint32_t         *TST_HASHFlowId,
                                        CRYS_FLOW_Params_t *pHASHFlowParamsInfo );
                                        
/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_FinishHASHFlow
 *  
 * Inputs:
 *  TST_index          - test index
 *  TST_HASHFlowId     - flow id
 *  TST_MasterTestName - test name
 *  blockSize          - block size for finish
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *	This function finishes HASH flow and check results.
 *
 * Algorithm:     
 *	1. Finish Flow
 *  2. Get results
 *  3. Compare flow output with expected output
 ******************************************************************************/                                
CRYSError_t CRYS_ATP_TST_FinishHASHFlow ( int                TST_index, 
                                         DxUint32_t          TST_HASHFlowId, 
                                         char               *TST_MasterTestName,
                                         DxUint32_t          blockSize,
                                         CRYS_FLOW_Params_t *pHASHFlowParamsInfo );
                                        




#ifdef __cplusplus
}
#endif

#endif

#endif
